package com.qboxus.tictic.adapters;

import android.content.Context;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;

import com.facebook.drawee.view.SimpleDraweeView;
import com.qboxus.tictic.R;
import com.qboxus.tictic.models.DraftVideoModel;
import com.qboxus.tictic.simpleclasses.Functions;

import java.io.File;
import java.util.ArrayList;

/**
 * Created by qboxus on 3/20/2018.
 */

public class DraftVideosAdapter extends RecyclerView.Adapter<DraftVideosAdapter.CustomViewHolder> {

    public Context context;
    private final OnItemClickListener listener;
    private final ArrayList<DraftVideoModel> dataList;


    public DraftVideosAdapter(Context context, ArrayList<DraftVideoModel> dataList, OnItemClickListener listener) {
        this.context = context;
        this.dataList = dataList;
        this.listener = listener;

    }

    @Override
    public CustomViewHolder onCreateViewHolder(ViewGroup viewGroup, int viewtype) {
        View view = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_galleryvideo_layout, viewGroup, false);
        return new CustomViewHolder(view);
    }

    @Override
    public int getItemCount() {
        return dataList.size();
    }

    @Override
    public void onBindViewHolder(final CustomViewHolder holder, final int i) {
        final DraftVideoModel item = dataList.get(i);

        holder.viewTxt.setText(item.video_time);

        if (item.video_path != null && !item.video_path.equals("")) {

            //video_path
            Uri uri = Uri.fromFile(new File(item.video_path));
            holder.thumbImage.setController(Functions.frescoImageLoad(uri, false));

        }

        holder.bind(i, item, listener);

    }


    public interface OnItemClickListener {
        void onItemClick(int postion, DraftVideoModel item, View view);
    }

    class CustomViewHolder extends RecyclerView.ViewHolder {


        SimpleDraweeView thumbImage;
        TextView viewTxt;
        ImageView crossBtn;

        public CustomViewHolder(View view) {
            super(view);

            thumbImage = view.findViewById(R.id.thumb_image);
            viewTxt = view.findViewById(R.id.view_txt);
            crossBtn = view.findViewById(R.id.cross_btn);

        }

        public void bind(final int position, final DraftVideoModel item, final OnItemClickListener listener) {
            itemView.setOnClickListener(v -> {
                listener.onItemClick(position, item, v);

            });

            crossBtn.setOnClickListener(v -> {
                listener.onItemClick(position, item, v);

            });

        }

    }

}